IF OBJECT_ID('UFD_EXP_CTB_MOV_VENDA_SECAO') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_EXP_CTB_MOV_VENDA_SECAO
	END
	
GO	
 
CREATE FUNCTION UFD_EXP_CTB_MOV_VENDA_SECAO(@CD_EMP		INT,
										    @CD_FILIAL	INT,
										    @DT_INI		DATETIME,
										    @DT_FIM		DATETIME)		

RETURNS @RS_RETURN TABLE(
		CD_EMP				     INT, 
		CD_FILIAL			     INT, 
		DT_VD				     DATETIME,
		CD_SC				     INT,
		DS_SC				     VARCHAR(100),
		CD_CTB_CNT_RED		     VARCHAR(50),
		CD_CTB_CNT			     VARCHAR(50),
		VLR_VD				     MONEY,
		VLR_ICMS			     MONEY,
		VLR_BASE_PIS_COFINS      MONEY,
	    RECARGA_DINH             MONEY	,
	    RECARGA_CARTAO           MONEY,
	    RECARGA_CHQ              MONEY,
		VLR_SERVICO              MONEY,
		VLR_LINX_PROMO_N_FISCAL  MONEY,
		VLR_LINX_PROMO_FISCAL    MONEY,
		RECEB_TERCEIROS_DINH     MONEY,
		RECEB_TERCEIROS_CARTAO   MONEY,
		RECEB_RPS_DINH           MONEY,
		RECEB_RPS_CARTAO         MONEY
		)  
AS
BEGIN			
	
	INSERT INTO @RS_RETURN
		SELECT 
			CD_EMP,
			CD_FILIAL,
			DT_VD,
			CD_SC,
			DS_SC,
			CD_CTB_CNT_RED,
			CD_CTB_CNT,
			VLR_VD,
			VLR_ICMS,
			VLR_BASE_PIS_COFINS,
			RECARGA_DINH      ,
			RECARGA_CARTAO    ,
			RECARGA_CHQ ,
			VLR_SERVICO ,
			VLR_LINX_PROMO_N_FISCAl,
			VLR_LINX_PROMO_FISCAL,
			RECEB_TERCEIROS_DINH ,
			RECEB_TERCEIROS_CARTAO,
			RECEB_RPS_DINH,
			RECEB_RPS_CARTAO       
		FROM UFD_PDV_VD_IT_RATEIO_POR_SECAO_CONTABIL(@CD_EMP, @CD_FILIAL, @DT_INI, @DT_FIM) 
        -- SELECT * FROM UFD_PDV_VD_IT_RATEIO_POR_SECAO_CONTABIL(1, 47, '20201019', '20201019') 
   RETURN 
    
END    

 